/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.IStdDialogContext;
import com.quantumdata.widgets.IStdDlgPanel;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class KeyBoardPanel
extends QDPanel
implements IStdDlgPanel,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static KeyBoardPanel g_keyboard = null;
    private static KeyBoardPanel g_numericPad = null;
    private GridBagLayout m_layout;
    private JTextField m_text;
    private Vector<KeyButton> m_keys = new Vector();
    private boolean m_capsOn = false;
    private Font m_font = new Font("Monospaced", 1, 20);
    private IStdDialogContext m_ctx = null;
    private StringBuffer m_buffer = new StringBuffer();
    private KeyHandler m_keyHandler = new KeyHandler();
    private boolean m_isNumeric;

    public static KeyBoardPanel getKeyboard() {
        if (g_keyboard == null) {
            g_keyboard = new KeyBoardPanel(false);
        }
        return g_keyboard;
    }

    public static KeyBoardPanel getNumberPad() {
        if (g_numericPad == null) {
            g_numericPad = new KeyBoardPanel(true);
        }
        return g_numericPad;
    }

    private KeyBoardPanel(boolean bl) {
        this.m_isNumeric = bl;
        if (this.m_isNumeric) {
            this.initNumberPadComponents();
        } else {
            this.initKeyBoardComponents();
        }
    }

    private void initKeyBoardComponents() {
        int n;
        this.m_layout = new GridBagLayout();
        this.setLayout(this.m_layout);
        this.addCmd("Cancel", "Cancel", 0, 0, 2);
        this.m_text = new JTextField();
        this.m_text.setFont(this.m_font);
        this.m_text.setCaretPosition(0);
        this.addComp(this.m_text, 2, 0, 9);
        this.addCmd("<--", "Left", 11, 0, 1);
        this.addCmd("-->", "Right", 12, 0, 1);
        String[] stringArray = new String[]{"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "="};
        String[] stringArray2 = new String[]{"~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+"};
        for (n = 0; n < stringArray.length; ++n) {
            this.addKey(stringArray[n], stringArray2[n], n, 1);
        }
        String[] stringArray3 = new String[]{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "[", "]", "\\"};
        String[] stringArray4 = new String[]{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "{", "}", "|"};
        for (n = 0; n < stringArray3.length; ++n) {
            this.addKey(stringArray3[n], stringArray4[n], n, 2);
        }
        String[] stringArray5 = new String[]{"a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "'"};
        String[] stringArray6 = new String[]{"A", "S", "D", "F", "G", "H", "J", "K", "L", ":", "\""};
        for (n = 0; n < stringArray5.length; ++n) {
            this.addKey(stringArray5[n], stringArray6[n], n, 3);
        }
        this.addCmd("Enter", "Enter", 11, 3, 2);
        String[] stringArray7 = new String[]{"z", "x", "c", "v", "b", "n", "m", ",", ".", "/"};
        String[] stringArray8 = new String[]{"Z", "X", "C", "V", "B", "N", "M", "<", ">", "?"};
        for (n = 0; n < stringArray7.length; ++n) {
            this.addKey(stringArray7[n], stringArray8[n], n, 4);
        }
        this.addCmd("Shift", "Shift", 10, 4, 3);
        this.addCmd("Space", "Space", 0, 5, 10);
        this.addCmd("Bsp", "Backspace", 10, 5, 1);
        this.addCmd("Del", "Delete", 11, 5, 1);
        this.addCmd("Ins", "Insert", 12, 5, 1);
    }

    private void initNumberPadComponents() {
        int n;
        this.m_layout = new GridBagLayout();
        this.setLayout(this.m_layout);
        this.m_text = new JTextField();
        this.m_text.setFont(this.m_font);
        this.m_text.setCaretPosition(0);
        this.addComp(this.m_text, 0, 0, 4);
        String[] stringArray = new String[]{"7", "8", "9"};
        for (n = 0; n < stringArray.length; ++n) {
            this.addKey(stringArray[n], stringArray[n], n, 1);
        }
        this.addCmd("Ins", "Insert", 3, 1, 1);
        String[] stringArray2 = new String[]{"4", "5", "6"};
        for (n = 0; n < stringArray2.length; ++n) {
            this.addKey(stringArray2[n], stringArray2[n], n, 2);
        }
        this.addCmd("Del", "Delete", 3, 2, 1);
        String[] stringArray3 = new String[]{"1", "2", "3"};
        for (n = 0; n < stringArray3.length; ++n) {
            this.addKey(stringArray3[n], stringArray3[n], n, 3);
        }
        this.addCmd("Bsp", "Backspace", 3, 3, 1);
        this.addKey("0", "0", 0, 4);
        this.addCmd("<--", "Left", 1, 4, 1);
        this.addCmd("-->", "Right", 2, 4, 1);
        this.addCmd(" C ", "Clear", 3, 4, 1);
        this.addCmd("Cancel", "Cancel", 0, 5, 2);
        this.addCmd("Enter", "Enter", 2, 5, 2);
    }

    private void addComp(Component component, int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = 1;
        this.m_layout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private QDButton addCmd(String string, String string2, int n, int n2, int n3) {
        QDButton qDButton = new QDButton(string);
        qDButton.setFont(this.m_font);
        qDButton.setActionCommand(string2);
        qDButton.addActionListener(this);
        this.addComp(qDButton, n, n2, n3);
        return qDButton;
    }

    private void addKey(String string, String string2, int n, int n2) {
        KeyButton keyButton = new KeyButton(string, string2);
        keyButton.setFont(this.m_font);
        keyButton.setAction(this.m_keyHandler);
        keyButton.setCapsOn(this.m_capsOn);
        this.m_keys.add(keyButton);
        this.addComp(keyButton, n, n2, 1);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setText(String string) {
        this.m_buffer = new StringBuffer(string);
        this.m_text.setText(this.m_buffer.toString());
        if (this.m_buffer.length() > 0) {
            this.m_text.setCaretPosition(this.m_buffer.length() - 1);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public void startingDlg(IStdDialogContext iStdDialogContext) {
        this.m_ctx = iStdDialogContext;
    }

    public void stoppingDlg(IStdDialogContext iStdDialogContext) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("shift")) {
            this.toggleCapsOn();
        } else if (string.equalsIgnoreCase("enter")) {
            this.m_ctx.stop("ok");
        } else if (string.equalsIgnoreCase("cancel")) {
            this.m_ctx.stop("cancel");
        } else if (string.equalsIgnoreCase("space")) {
            this.m_buffer.append(" ");
            this.m_text.setText(this.m_buffer.toString());
            this.m_text.setCaretPosition(this.m_buffer.length() - 1);
        } else if (string.equalsIgnoreCase("Backspace") && (n = this.m_buffer.length()) > 0) {
            this.m_buffer.deleteCharAt(this.m_buffer.length() - 1);
            this.m_text.setText(this.m_buffer.toString());
            if (n > 1) {
                this.m_text.setCaretPosition(this.m_buffer.length() - 1);
            }
        }
    }

    private void toggleCapsOn() {
        this.m_capsOn = !this.m_capsOn;
        for (KeyButton keyButton : this.m_keys) {
            keyButton.setCapsOn(this.m_capsOn);
        }
    }

    class KeyButton
    extends QDButton {
        private static final long serialVersionUID = 1L;
        private String m_normal;
        private String m_caps;

        public KeyButton(String string, String string2) {
            this.m_normal = string;
            this.m_caps = string2;
            this.setCapsOn(false);
        }

        public void setCapsOn(boolean bl) {
            String string = bl ? this.m_caps : this.m_normal;
            this.setText(" " + string + " ");
        }

        public String getKey(boolean bl) {
            if (bl) {
                return this.m_caps;
            }
            return this.m_normal;
        }
    }

    class KeyHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            KeyButton keyButton = (KeyButton)actionEvent.getSource();
            KeyBoardPanel.this.m_buffer.append(keyButton.getKey(KeyBoardPanel.this.m_capsOn));
            KeyBoardPanel.this.m_text.setText(KeyBoardPanel.this.m_buffer.toString());
            KeyBoardPanel.this.m_text.setCaretPosition(KeyBoardPanel.this.m_buffer.length() - 1);
        }
    }
}

